import { string } from 'alga-js'
import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import getTokenHelper from "../../../utils/getTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const id = getRouterParam(event, 'id')

  const selectFields = [
    'IsCommissioned',
    'IsCommissionedConfirmed',
    'ack_commissioned_laravel',
    'shipping_date',
    'M_Paket_Type_ID',
    'ext_freight_co2',
    'ext_freight_energy',
    'ext_freight_cost',
    'ext_freight_weight',
    'shipping_service_name',
    'isDHLKleinPaket',
    'isplentyinprogress',
    'isAccountingExported',
    'isExportedPaketAccounting',
    'ext_freight_total',
    'int_freight_total',
    'int_freight_co2',
    'int_freight_energy',
    'int_freight_cost',
    'dhl_product_id',
    'dhl_product_description',
    'isExternalFeeAccounted',
    'isShippingFeeAccounted'
  ].join(',')

  const res: any = await fetchHelper(
    event,
    `models/m_inout/${id}?$select=${selectFields}&$expand=M_Paket_Type_ID($select=Name)`,
    'GET',
    token,
    null
  )

  if (res) {
    data = res
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})
